export const csr = false;
export const prerender = true;

import { config } from '$lib/site.config';
import fs from 'node:fs';
import fm from 'front-matter';
import { marked } from 'marked';
import path from 'node:path';
import dayjs from 'dayjs';

export async function load() {
	const dir = fs
		.readdirSync(config.path, { withFileTypes: true })
		.filter(
			(element) => element.isFile() && config.renderFileTypes.includes(path.parse(element.name).ext)
		)
		.map((element) => element.name);
	const files = [];
	for (const file of dir) {
		const raw = fs.readFileSync(path.resolve(config.path, file), { encoding: 'utf-8' });
		files.push({
			path: file,
			name: path.parse(file).name,
			title:
				marked.lexer(fm(raw).body).find((token) => token.type === 'heading' && token.depth === 1)
					.text || 'null',
			date: fm(raw).attributes.date
		});
	}
	files.sort((a, b) => {
		return Number(-(dayjs(a.date).valueOf() - dayjs(b.date).valueOf()));
	});
	return {
		files: files
	};
}
